/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.UnsupportedAudioFileException;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;

public class MainWindow
extends JFrame {
    static JPanel contentPane;
    public static int mouseXClick;
    public static int mouseYClick;

    static {
        mouseXClick = -1;
        mouseYClick = -1;
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    MainWindow frame = new MainWindow();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public MainWindow() throws LineUnavailableException {
        this.setCursor(Cursor.getPredefinedCursor(1));
        this.setTitle("Tim Andrew's Screensaver");
        this.setMinimumSize(new Dimension(232, 148));
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 591, 360);
        contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(contentPane);
        contentPane.setLayout(new CardLayout(0, 0));
        final AnimationScreen animationScreen = new AnimationScreen();
        animationScreen.setBackground(Color.black);
        animationScreen.setToolTipText("<html><body>Left Click = Add Shape<BR><BR>Right Click = Toggle Background<BR><BR>Middle Click = Reset Shapes</html></body>");
        animationScreen.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                mouseXClick = e.getX();
                mouseYClick = e.getY();
                if (SwingUtilities.isRightMouseButton(e)) {
                    if (animationScreen.getBackground() == Color.black) {
                        animationScreen.setBackground(Color.white);
                    } else {
                        animationScreen.setBackground(Color.black);
                    }
                } else if (SwingUtilities.isMiddleMouseButton(e)) {
                    AnimationScreen.shapesArray.clear();
                } else {
                    AnimationScreen.addShape();
                }
                mouseXClick = -1;
                mouseYClick = -1;
            }
        });
        contentPane.add((Component)animationScreen, "name_188603560227855");
        try {
            AudioInputStream bgMusic = AudioSystem.getAudioInputStream(MainWindow.class.getResource("/wav/CommonMan.wav"));
            Clip music = AudioSystem.getClip();
            music.open(bgMusic);
            music.loop(999);
        }
        catch (UnsupportedAudioFileException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

