/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JPanel;
import javax.swing.Timer;

public class AnimationScreen
extends JPanel {
    private Timer timer = new Timer(1, new TimerAction());
    private static int screenWidth = 0;
    private static int screenHeight = 0;
    private static int borderOffset = 9;
    static List<Object> shapesArray = new ArrayList<Object>();

    @Override
    public void paintComponent(Graphics g) {
        int i;
        this.setScreenDimensions();
        super.paintComponent(g);
        Graphics2D g2d = (Graphics2D)g;
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (shapesArray.size() == 0) {
            i = 1;
            while (i <= 4) {
                AnimationScreen.addShape();
                ++i;
            }
        }
        i = 0;
        while (i < shapesArray.size()) {
            Shape shape = (Shape)shapesArray.get(i);
            Rectangle shapeRect = new Rectangle(shape.getX(), shape.getY(), shape.getWidth(), shape.getHeight());
            int j = 0;
            while (j < shapesArray.size()) {
                Shape checkShape;
                Rectangle checkRect;
                if (i != j && shapeRect.intersects(checkRect = new Rectangle((checkShape = (Shape)shapesArray.get(j)).getX(), checkShape.getY(), checkShape.getWidth(), checkShape.getHeight()))) {
                    if (shape.getX() + shape.getWidth() - 1 == checkShape.getX()) {
                        shape.setXDirection("-");
                        if (checkShape.getXDirection().equals("-")) {
                            checkShape.setXDirection("+");
                        } else if (checkShape.getXDirection().equals("+")) {
                            checkShape.setXDirection("-");
                        }
                    } else if (shape.getX() + 1 == checkShape.getX() + checkShape.getWidth()) {
                        shape.setXDirection("+");
                        if (checkShape.getXDirection().equals("-")) {
                            checkShape.setXDirection("+");
                        } else if (checkShape.getXDirection().equals("+")) {
                            checkShape.setXDirection("-");
                        }
                    }
                    if (shape.getY() + shape.getHeight() - 1 == checkShape.getY()) {
                        shape.setYDirection("-");
                        if (checkShape.getYDirection().equals("-")) {
                            checkShape.setYDirection("+");
                        } else if (checkShape.getYDirection().equals("+")) {
                            checkShape.setYDirection("-");
                        }
                    } else if (shape.getY() + 1 == checkShape.getY() + checkShape.getHeight()) {
                        shape.setYDirection("+");
                        if (checkShape.getYDirection().equals("-")) {
                            checkShape.setYDirection("+");
                        } else if (checkShape.getYDirection().equals("+")) {
                            checkShape.setYDirection("-");
                        }
                    }
                }
                ++j;
            }
            String classChecker = shapesArray.get(i).toString().substring(0, shapesArray.get(i).toString().indexOf("@"));
            if (classChecker.equalsIgnoreCase("circle")) {
                Circle circle = (Circle)shapesArray.get(i);
                circle.draw(shapesArray.get(i), g2d, screenWidth, screenHeight, borderOffset);
            }
            if (classChecker.equalsIgnoreCase("oval")) {
                Oval oval = (Oval)shapesArray.get(i);
                oval.draw(shapesArray.get(i), g2d, screenWidth, screenHeight, borderOffset);
            }
            if (classChecker.equalsIgnoreCase("square")) {
                Square square = (Square)shapesArray.get(i);
                square.draw(shapesArray.get(i), g2d, screenWidth, screenHeight, borderOffset);
            }
            if (classChecker.equalsIgnoreCase("rect")) {
                Rect rectangle = (Rect)shapesArray.get(i);
                rectangle.draw(shapesArray.get(i), g2d, screenWidth, screenHeight, borderOffset);
            }
            if (classChecker.equalsIgnoreCase("hourglass")) {
                HourGlass hourGlass = (HourGlass)shapesArray.get(i);
                hourGlass.draw(shapesArray.get(i), g2d, screenWidth, screenHeight, borderOffset);
            }
            this.timer.start();
            ++i;
        }
    }

    private void setScreenDimensions() {
        Rectangle screenDimensions = MainWindow.contentPane.getBounds();
        screenWidth = (int)screenDimensions.getWidth();
        screenHeight = (int)screenDimensions.getHeight();
    }

    public static void addShape() {
        int shapeToAdd = Randomize.shape();
        switch (shapeToAdd) {
            case 0: {
                Circle circle = AnimationScreen.addCircle();
                shapesArray.add(circle);
                break;
            }
            case 1: {
                Oval oval = AnimationScreen.addOval();
                shapesArray.add(oval);
                break;
            }
            case 2: {
                Square square = AnimationScreen.addSquare();
                shapesArray.add(square);
                break;
            }
            case 3: {
                Rect rectangle = AnimationScreen.addRectangle();
                shapesArray.add(rectangle);
                break;
            }
            case 4: {
                HourGlass hourGlass = AnimationScreen.addHourGlass();
                shapesArray.add(hourGlass);
            }
        }
    }

    private static Circle addCircle() {
        Circle circle = new Circle(Randomize.coordinates(screenWidth), Randomize.coordinates(screenHeight), Randomize.dimensions(), Randomize.rgb(), Randomize.rgb(), Randomize.rgb());
        if (MainWindow.mouseXClick >= 0 && MainWindow.mouseYClick >= 0) {
            circle.setX(MainWindow.mouseXClick - circle.getWidth() / 2);
            circle.setY(MainWindow.mouseYClick - circle.getHeight() / 2);
        }
        while (circle.getX() + circle.getWidth() >= screenWidth - borderOffset) {
            circle.setX(circle.getX() - 1);
        }
        while (circle.getY() + circle.getHeight() >= screenHeight - borderOffset) {
            circle.setY(circle.getY() - 1);
        }
        return circle;
    }

    private static Oval addOval() {
        Oval oval = new Oval(Randomize.coordinates(screenWidth), Randomize.coordinates(screenHeight), Randomize.dimensions(), Randomize.dimensions(), Randomize.rgb(), Randomize.rgb(), Randomize.rgb());
        if (MainWindow.mouseXClick >= 0 && MainWindow.mouseYClick >= 0) {
            oval.setX(MainWindow.mouseXClick - oval.getWidth() / 2);
            oval.setY(MainWindow.mouseYClick - oval.getHeight() / 2);
        }
        while (oval.getX() + oval.getWidth() >= screenWidth - borderOffset) {
            oval.setX(oval.getX() - 1);
        }
        while (oval.getY() + oval.getHeight() >= screenHeight - borderOffset) {
            oval.setY(oval.getY() - 1);
        }
        return oval;
    }

    private static Square addSquare() {
        Square square = new Square(Randomize.coordinates(screenWidth), Randomize.coordinates(screenHeight), Randomize.dimensions(), Randomize.rgb(), Randomize.rgb(), Randomize.rgb());
        if (MainWindow.mouseXClick >= 0 && MainWindow.mouseYClick >= 0) {
            square.setX(MainWindow.mouseXClick - square.getWidth() / 2);
            square.setY(MainWindow.mouseYClick - square.getHeight() / 2);
        }
        while (square.getX() + square.getWidth() >= screenWidth - borderOffset) {
            square.setX(square.getX() - 1);
        }
        while (square.getY() + square.getHeight() >= screenHeight - borderOffset) {
            square.setY(square.getY() - 1);
        }
        return square;
    }

    private static Rect addRectangle() {
        Rect rect = new Rect(Randomize.coordinates(screenWidth), Randomize.coordinates(screenHeight), Randomize.dimensions(), Randomize.dimensions(), Randomize.rgb(), Randomize.rgb(), Randomize.rgb());
        if (MainWindow.mouseXClick >= 0 && MainWindow.mouseYClick >= 0) {
            rect.setX(MainWindow.mouseXClick - rect.getWidth() / 2);
            rect.setY(MainWindow.mouseYClick - rect.getHeight() / 2);
        }
        while (rect.getX() + rect.getWidth() >= screenWidth - borderOffset) {
            rect.setX(rect.getX() - 1);
        }
        while (rect.getY() + rect.getHeight() >= screenHeight - borderOffset) {
            rect.setY(rect.getY() - 1);
        }
        return rect;
    }

    private static HourGlass addHourGlass() {
        HourGlass hourGlass = new HourGlass(Randomize.coordinates(screenWidth), Randomize.coordinates(screenHeight), Randomize.dimensions(), Randomize.dimensions(), Randomize.rgb(), Randomize.rgb(), Randomize.rgb());
        if (MainWindow.mouseXClick >= 0 && MainWindow.mouseYClick >= 0) {
            hourGlass.setX(MainWindow.mouseXClick - hourGlass.getWidth() / 2);
            hourGlass.setY(MainWindow.mouseYClick - hourGlass.getHeight() / 2);
        }
        while (hourGlass.getX() + hourGlass.getWidth() >= screenWidth - borderOffset) {
            hourGlass.setX(hourGlass.getX() - 1);
        }
        while (hourGlass.getY() + hourGlass.getHeight() >= screenHeight - borderOffset) {
            hourGlass.setY(hourGlass.getY() - 1);
        }
        return hourGlass;
    }

    private class TimerAction
    implements ActionListener {
        private TimerAction() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            AnimationScreen.this.repaint();
        }
    }
}

