/*
 * Decompiled with CFR 0.152.
 */
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class Battle {
    private Human human;
    private Computer computer;
    private Random randomize = new Random();
    private List<String> battleOutput = new ArrayList<String>();

    public Battle(Human user, Computer hal2001) {
        this.human = user;
        this.computer = hal2001;
    }

    private int coinToss() {
        int coinTossResult = this.randomize.nextInt(2);
        return coinTossResult;
    }

    private int rollDice() {
        int rolledDice = this.randomize.nextInt(200) + 50;
        return rolledDice;
    }

    private int currentAttack(int attackerAttack, int opponentMaterial) {
        double attackerDamage = 0.0;
        double opponentDefense = 0.0;
        int roll = this.rollDice();
        switch (attackerAttack) {
            case 1: {
                attackerDamage = Attack.getSpinDamage();
                break;
            }
            case 2: {
                attackerDamage = Attack.getSlideDamage();
                break;
            }
            case 3: {
                attackerDamage = Attack.getLeapDamage();
                break;
            }
            case 4: {
                attackerDamage = Attack.getCrushDamage();
            }
        }
        double damage = (attackerDamage / 100.0 + 1.0) * (double)roll;
        switch (opponentMaterial) {
            case 1: {
                opponentDefense = Material.getGlassProtection();
                break;
            }
            case 2: {
                opponentDefense = Material.getSilverProtection();
                break;
            }
            case 3: {
                opponentDefense = Material.getGoldProtection();
                break;
            }
            case 4: {
                opponentDefense = Material.getGrapheneProtection();
            }
        }
        double defense = damage - damage * (opponentDefense / 100.0);
        int damageDone = (int)defense;
        return damageDone;
    }

    public String[] getBattleOutput() {
        int initialHealth = this.human.getHealth();
        int coinTossResult = this.coinToss();
        this.battleOutput.add("The Battle Begins!");
        this.battleOutput.add("");
        while (this.human.getHealth() > 0 && this.computer.getHealth() > 0) {
            int attack;
            if (coinTossResult == 1) {
                attack = this.currentAttack(this.human.getAttack(), this.computer.getMaterial());
                this.computer.setHealth(this.computer.getHealth() - attack);
                this.battleOutput.add(String.valueOf(this.human.getName()) + " attacks the Computer, causing " + String.valueOf(attack) + " damage.");
                this.battleOutput.add("The Computer's health is now " + String.valueOf(this.computer.getHealth()) + "/" + String.valueOf(initialHealth) + ".");
                this.battleOutput.add("");
                coinTossResult = 0;
                continue;
            }
            attack = this.currentAttack(this.computer.getAttack(), this.human.getMaterial());
            this.human.setHealth(this.human.getHealth() - attack);
            this.battleOutput.add("The Computer attacks " + this.human.getName() + ", causing " + String.valueOf(attack) + " damage.");
            this.battleOutput.add(String.valueOf(this.human.getName()) + "'s health is now " + String.valueOf(this.human.getHealth()) + "/" + String.valueOf(initialHealth) + ".");
            this.battleOutput.add("");
            coinTossResult = 1;
        }
        if (this.human.getHealth() > 0) {
            this.battleOutput.add(String.valueOf(this.human.getName()) + " has defeated the Computer!");
            this.battleOutput.add("You won!");
        } else {
            this.battleOutput.add("The Computer has defeated " + this.human.getName() + "!");
            this.battleOutput.add("You lost!");
        }
        String[] finalOutput = new String[this.battleOutput.size()];
        finalOutput = this.battleOutput.toArray(finalOutput);
        return finalOutput;
    }
}

