/*
 * Decompiled with CFR 0.152.
 */
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.EmptyBorder;

public class AntarticWildlifeTracking
extends JFrame {
    private double latitude;
    private double longitude;
    private String sex;
    private int weight;
    private String species;
    private String bloodPressure;
    private int spots;
    private String dental;
    private List<String> trackingData;
    private JPanel contentPane;
    private JTextField txtGPSLatitude;
    private JLabel lblGPSLatitude;
    private JLabel lblGPSLongitude;
    private JTextField txtGPSLongitude;
    private JButton btnAnimalPenguin;
    private JButton btnAnimalSeaLion;
    private JButton btnAnimalWalrus;
    private JLabel lblGPSTitle;
    private JLabel lblAnimalTitle;
    private JButton btnAnimalBack;
    private JPanel pnlPenguin;
    private JPanel pnlWalrus;
    private JPanel pnlSeaLion;
    private JPanel pnlSaved;
    private JButton btnSavedContinue;
    private JLabel btnSavedData;
    private JLabel lblPenguinTItle;
    private JButton btnPenguinBack;
    private JButton btnGPSReset;
    private JPanel pnlReport;
    private JButton btnReportContinue;
    private JLabel lblReportTitle;
    private JButton btnTrackPenguin;
    private JTextField txtPenguinBloodPressure;
    private JButton btnWalrusBack;
    private JButton btnWalrusTrack;
    private JLabel lblWalrusDentalHealth;
    private JLabel lblWalrusWeight;
    private JSpinner spnWalrusWeight;
    private JComboBox cboWalrusSex;
    private JLabel lblWalrusSex;
    private JLabel lblWalrusTitle;
    private JComboBox cboWalrusDentalHealth;
    private JLabel lblSeaLionTitle;
    private JLabel lblSeaLionSex;
    private JComboBox cboSeaLionSex;
    private JSpinner spnSeaLionWeight;
    private JLabel lblSeaLionWeight;
    private JLabel lblSeaLionNumberOfSpots;
    private JButton btnSeaLionTrack;
    private JButton btnSeaLionBack;
    private JSpinner spnSeaLionSpots;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    AntarticWildlifeTracking frame = new AntarticWildlifeTracking();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public AntarticWildlifeTracking() {
        this.setResizable(false);
        this.setTitle("Antartic Wildlife Tracker");
        this.setDefaultCloseOperation(3);
        this.setBounds(100, 100, 818, 658);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setContentPane(this.contentPane);
        this.contentPane.setLayout(new CardLayout(0, 0));
        final Panel pnlGPS = new Panel();
        this.contentPane.add((Component)pnlGPS, "name_49610055079111");
        pnlGPS.setLayout(null);
        final Panel pnlAnimal = new Panel();
        this.contentPane.add((Component)pnlAnimal, "name_45584387693432");
        pnlAnimal.setLayout(null);
        this.lblGPSTitle = new JLabel("ENTER CURRENT GPS LOCATION");
        this.lblGPSTitle.setFont(new Font("Tahoma", 0, 39));
        this.lblGPSTitle.setHorizontalAlignment(0);
        this.lblGPSTitle.setBounds(12, 31, 778, 73);
        pnlGPS.add(this.lblGPSTitle);
        this.lblGPSLatitude = new JLabel("LATITUDE (\u201390 to +90)");
        this.lblGPSLatitude.setHorizontalAlignment(4);
        this.lblGPSLatitude.setFont(new Font("Tahoma", 1, 16));
        this.lblGPSLatitude.setBounds(33, 175, 245, 16);
        pnlGPS.add(this.lblGPSLatitude);
        this.txtGPSLatitude = new JTextField();
        this.txtGPSLatitude.setFont(new Font("Tahoma", 1, 16));
        this.txtGPSLatitude.setBounds(290, 175, 275, 22);
        pnlGPS.add(this.txtGPSLatitude);
        this.txtGPSLatitude.setColumns(10);
        this.lblGPSLongitude = new JLabel("LONGITUDE (\u2013180 to +180)");
        this.lblGPSLongitude.setHorizontalAlignment(4);
        this.lblGPSLongitude.setFont(new Font("Tahoma", 1, 16));
        this.lblGPSLongitude.setBounds(33, 220, 245, 16);
        pnlGPS.add(this.lblGPSLongitude);
        this.txtGPSLongitude = new JTextField();
        this.txtGPSLongitude.setFont(new Font("Tahoma", 1, 16));
        this.txtGPSLongitude.setColumns(10);
        this.txtGPSLongitude.setBounds(290, 220, 275, 22);
        pnlGPS.add(this.txtGPSLongitude);
        try {
            this.trackingData = ReadWrite.readFile();
        }
        catch (IOException e2) {
            e2.printStackTrace();
            File f = new File("trackingData.txt");
            try {
                f.createNewFile();
                JOptionPane.showMessageDialog(pnlGPS, "New trackingData.txt file created!", "Alert", 2);
            }
            catch (IOException e1) {
                e1.printStackTrace();
                JOptionPane.showMessageDialog(pnlGPS, "trackingData.txt not found and could not be created!\nPlease create manually!", "Warning", 2);
            }
        }
        JButton btnGPSTrack = new JButton("TRACK");
        btnGPSTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AntarticWildlifeTracking.this.txtGPSLongitude.getText().length() < 1 || AntarticWildlifeTracking.this.txtGPSLatitude.getText().length() < 1) {
                    JOptionPane.showMessageDialog(pnlGPS, "Both fields must have valid coordinates!", "Warning", 2);
                } else if (RegEx.checkLatitude(AntarticWildlifeTracking.this.txtGPSLatitude.getText()) && RegEx.checkLongitude(AntarticWildlifeTracking.this.txtGPSLongitude.getText())) {
                    AntarticWildlifeTracking.this.longitude = Double.parseDouble(AntarticWildlifeTracking.this.txtGPSLongitude.getText());
                    AntarticWildlifeTracking.this.latitude = Double.parseDouble(AntarticWildlifeTracking.this.txtGPSLatitude.getText());
                    pnlGPS.setVisible(false);
                    pnlAnimal.setVisible(true);
                } else {
                    JOptionPane.showMessageDialog(pnlGPS, "<html><body><p>Latitude must be between \u201390 and +90!</p><p>Longitude must be between \u2013180 to +180!</p><p>No more than 10 decimal places!</p></body></html>", "Warning", 2);
                }
            }
        });
        btnGPSTrack.setFont(new Font("Tahoma", 1, 16));
        btnGPSTrack.setBounds(585, 175, 175, 67);
        pnlGPS.add(btnGPSTrack);
        this.pnlReport = new JPanel();
        this.contentPane.add((Component)this.pnlReport, "name_54675023503012");
        this.pnlReport.setLayout(null);
        JScrollPane scpReport = new JScrollPane();
        scpReport.setVerticalScrollBarPolicy(22);
        scpReport.setBounds(0, 69, 802, 427);
        this.pnlReport.add(scpReport);
        final JTextArea txtReport = new JTextArea();
        txtReport.setEditable(false);
        scpReport.setViewportView(txtReport);
        JButton btnGPSViewReport = new JButton("View Report");
        btnGPSViewReport.setFont(new Font("Tahoma", 1, 16));
        btnGPSViewReport.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                txtReport.setText("");
                try {
                    AntarticWildlifeTracking.this.trackingData = ReadWrite.readFile();
                    int i = 0;
                    while (i < AntarticWildlifeTracking.this.trackingData.size()) {
                        txtReport.append((String)AntarticWildlifeTracking.this.trackingData.get(i));
                        txtReport.append("\n");
                        ++i;
                    }
                    pnlGPS.setVisible(false);
                    AntarticWildlifeTracking.this.pnlReport.setVisible(true);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    JOptionPane.showMessageDialog(pnlGPS, "File Error! trackingData.txt missing from directory!", "Warning", 2);
                }
            }
        });
        this.btnGPSReset = new JButton("RESET FIELDS");
        this.btnGPSReset.setFont(new Font("Tahoma", 1, 16));
        this.btnGPSReset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntarticWildlifeTracking.this.txtGPSLatitude.setText("");
                AntarticWildlifeTracking.this.txtGPSLongitude.setText("");
            }
        });
        this.btnGPSReset.setBounds(290, 255, 275, 22);
        pnlGPS.add(this.btnGPSReset);
        btnGPSViewReport.setBounds(0, 388, 802, 134);
        pnlGPS.add(btnGPSViewReport);
        this.btnAnimalPenguin = new JButton("PENGUIN");
        this.btnAnimalPenguin.setFont(new Font("Tahoma", 1, 22));
        this.btnAnimalPenguin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pnlAnimal.setVisible(false);
                AntarticWildlifeTracking.this.pnlPenguin.setVisible(true);
            }
        });
        this.lblAnimalTitle = new JLabel("SELECT ANIMAL TO TRACK");
        this.lblAnimalTitle.setHorizontalAlignment(0);
        this.lblAnimalTitle.setFont(new Font("Tahoma", 0, 39));
        this.lblAnimalTitle.setBounds(12, 31, 778, 73);
        pnlAnimal.add(this.lblAnimalTitle);
        this.btnAnimalPenguin.setIcon(new ImageIcon(AntarticWildlifeTracking.class.getResource("/img/penguin.png")));
        this.btnAnimalPenguin.setBounds(0, 117, 802, 112);
        pnlAnimal.add(this.btnAnimalPenguin);
        this.btnAnimalSeaLion = new JButton("SEA LION");
        this.btnAnimalSeaLion.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pnlAnimal.setVisible(false);
                AntarticWildlifeTracking.this.pnlSeaLion.setVisible(true);
            }
        });
        this.btnAnimalSeaLion.setFont(new Font("Tahoma", 1, 22));
        this.btnAnimalSeaLion.setIcon(new ImageIcon(AntarticWildlifeTracking.class.getResource("/img/seaLion.png")));
        this.btnAnimalSeaLion.setBounds(0, 267, 802, 112);
        pnlAnimal.add(this.btnAnimalSeaLion);
        this.btnAnimalWalrus = new JButton("WALRUS");
        this.btnAnimalWalrus.setFont(new Font("Tahoma", 1, 22));
        this.btnAnimalWalrus.setIcon(new ImageIcon(AntarticWildlifeTracking.class.getResource("/img/walrus.png")));
        this.btnAnimalWalrus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pnlAnimal.setVisible(false);
                AntarticWildlifeTracking.this.pnlWalrus.setVisible(true);
            }
        });
        this.btnAnimalWalrus.setBounds(0, 417, 802, 112);
        pnlAnimal.add(this.btnAnimalWalrus);
        this.btnAnimalBack = new JButton("BACK");
        this.btnAnimalBack.setFont(new Font("Tahoma", 1, 18));
        this.btnAnimalBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                pnlAnimal.setVisible(false);
                pnlGPS.setVisible(true);
            }
        });
        this.btnAnimalBack.setBounds(361, 542, 97, 71);
        pnlAnimal.add(this.btnAnimalBack);
        this.pnlPenguin = new JPanel();
        this.contentPane.add((Component)this.pnlPenguin, "name_53773138189432");
        this.pnlPenguin.setLayout(null);
        this.lblPenguinTItle = new JLabel("PENGUIN DETAILS:");
        this.lblPenguinTItle.setIcon(new ImageIcon(AntarticWildlifeTracking.class.getResource("/img/penguin.png")));
        this.lblPenguinTItle.setHorizontalAlignment(0);
        this.lblPenguinTItle.setFont(new Font("Tahoma", 0, 39));
        this.lblPenguinTItle.setBounds(12, 31, 778, 73);
        this.pnlPenguin.add(this.lblPenguinTItle);
        JLabel lblPenguinSex = new JLabel("SEX");
        lblPenguinSex.setFont(new Font("Tahoma", 1, 16));
        lblPenguinSex.setBounds(172, 148, 356, 16);
        this.pnlPenguin.add(lblPenguinSex);
        final JComboBox<String> cboPenguinSex = new JComboBox<String>();
        cboPenguinSex.setFont(new Font("Tahoma", 1, 16));
        cboPenguinSex.setModel(new DefaultComboBoxModel<String>(new String[]{"Male", "Female"}));
        cboPenguinSex.setBounds(522, 142, 100, 22);
        this.pnlPenguin.add(cboPenguinSex);
        JLabel lblPenguinWeight = new JLabel("WEIGHT (KG)");
        lblPenguinWeight.setFont(new Font("Tahoma", 1, 16));
        lblPenguinWeight.setBounds(172, 231, 356, 16);
        this.pnlPenguin.add(lblPenguinWeight);
        final JSpinner spnPenguinWeight = new JSpinner();
        spnPenguinWeight.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        spnPenguinWeight.setFont(new Font("Tahoma", 1, 16));
        spnPenguinWeight.setBounds(522, 225, 100, 22);
        this.pnlPenguin.add(spnPenguinWeight);
        JLabel lblBloodPressure = new JLabel("BLOOD PRESSURE (SYSTOLIC/DIASTOLIC)");
        lblBloodPressure.setFont(new Font("Tahoma", 1, 16));
        lblBloodPressure.setBounds(172, 315, 356, 16);
        this.pnlPenguin.add(lblBloodPressure);
        this.txtPenguinBloodPressure = new JTextField();
        this.txtPenguinBloodPressure.setFont(new Font("Tahoma", 1, 16));
        this.txtPenguinBloodPressure.setBounds(522, 312, 100, 22);
        this.pnlPenguin.add(this.txtPenguinBloodPressure);
        this.txtPenguinBloodPressure.setColumns(10);
        this.btnTrackPenguin = new JButton("TRACK PENGUIN");
        this.btnTrackPenguin.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (RegEx.checkPenguinBP(AntarticWildlifeTracking.this.txtPenguinBloodPressure.getText())) {
                    AntarticWildlifeTracking.this.species = "Penguin";
                    if (cboPenguinSex.getSelectedIndex() == 0) {
                        AntarticWildlifeTracking.this.sex = "Male";
                    } else {
                        AntarticWildlifeTracking.this.sex = "Female";
                    }
                    AntarticWildlifeTracking.this.weight = (Integer)spnPenguinWeight.getValue();
                    AntarticWildlifeTracking.this.bloodPressure = AntarticWildlifeTracking.this.txtPenguinBloodPressure.getText();
                    GPS GPSData = new GPS(AntarticWildlifeTracking.this.latitude, AntarticWildlifeTracking.this.longitude);
                    Penguin penguin = new Penguin(AntarticWildlifeTracking.this.species, AntarticWildlifeTracking.this.sex, AntarticWildlifeTracking.this.weight, AntarticWildlifeTracking.this.bloodPressure, GPSData);
                    try {
                        ReadWrite.writeFile(penguin.createRecord());
                        AntarticWildlifeTracking.this.cboSeaLionSex.setSelectedIndex(0);
                        AntarticWildlifeTracking.this.spnSeaLionWeight.setValue(new Integer(0));
                        AntarticWildlifeTracking.this.spnSeaLionSpots.setValue(new Integer(0));
                        AntarticWildlifeTracking.this.cboWalrusSex.setSelectedIndex(0);
                        AntarticWildlifeTracking.this.spnWalrusWeight.setValue(new Integer(0));
                        AntarticWildlifeTracking.this.cboWalrusDentalHealth.setSelectedIndex(0);
                        cboPenguinSex.setSelectedIndex(0);
                        spnPenguinWeight.setValue(new Integer(0));
                        AntarticWildlifeTracking.this.txtPenguinBloodPressure.setText("");
                        AntarticWildlifeTracking.this.pnlPenguin.setVisible(false);
                        AntarticWildlifeTracking.this.pnlSaved.setVisible(true);
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                        JOptionPane.showMessageDialog(AntarticWildlifeTracking.this.pnlPenguin, "File Error! trackingData.txt missing from directory!!", "Warning", 2);
                    }
                } else {
                    JOptionPane.showMessageDialog(pnlGPS, "<html><body><p>Blood Pressure (SYSTOLIC/DIASTOLIC) must be in the format:</p><p>###/###</p></body></html>", "Warning", 2);
                }
            }
        });
        this.btnTrackPenguin.setFont(new Font("Tahoma", 1, 16));
        this.btnTrackPenguin.setBounds(0, 415, 802, 130);
        this.pnlPenguin.add(this.btnTrackPenguin);
        this.btnPenguinBack = new JButton("BACK");
        this.btnPenguinBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntarticWildlifeTracking.this.pnlPenguin.setVisible(false);
                pnlAnimal.setVisible(true);
            }
        });
        this.btnPenguinBack.setFont(new Font("Tahoma", 1, 18));
        this.btnPenguinBack.setBounds(364, 558, 97, 55);
        this.pnlPenguin.add(this.btnPenguinBack);
        this.pnlWalrus = new JPanel();
        this.pnlWalrus.setLayout(null);
        this.contentPane.add((Component)this.pnlWalrus, "name_53847437047308");
        this.lblWalrusTitle = new JLabel("WALRUS DETAILS:");
        this.lblWalrusTitle.setIcon(new ImageIcon(AntarticWildlifeTracking.class.getResource("/img/walrus.png")));
        this.lblWalrusTitle.setHorizontalAlignment(0);
        this.lblWalrusTitle.setFont(new Font("Tahoma", 0, 39));
        this.lblWalrusTitle.setBounds(12, 31, 778, 73);
        this.pnlWalrus.add(this.lblWalrusTitle);
        this.lblWalrusSex = new JLabel("SEX");
        this.lblWalrusSex.setFont(new Font("Tahoma", 1, 16));
        this.lblWalrusSex.setBounds(172, 148, 177, 16);
        this.pnlWalrus.add(this.lblWalrusSex);
        this.cboWalrusSex = new JComboBox();
        this.cboWalrusSex.setModel(new DefaultComboBoxModel<String>(new String[]{"MALE", "FEMALE"}));
        this.cboWalrusSex.setFont(new Font("Tahoma", 1, 16));
        this.cboWalrusSex.setBounds(511, 144, 100, 22);
        this.pnlWalrus.add(this.cboWalrusSex);
        this.lblWalrusWeight = new JLabel("WEIGHT (KG)");
        this.lblWalrusWeight.setFont(new Font("Tahoma", 1, 16));
        this.lblWalrusWeight.setBounds(172, 231, 177, 16);
        this.pnlWalrus.add(this.lblWalrusWeight);
        this.spnWalrusWeight = new JSpinner();
        this.spnWalrusWeight.setModel(new SpinnerNumberModel(0, 0, 10000, 1));
        this.spnWalrusWeight.setFont(new Font("Tahoma", 1, 16));
        this.spnWalrusWeight.setBounds(511, 227, 100, 22);
        this.pnlWalrus.add(this.spnWalrusWeight);
        this.lblWalrusDentalHealth = new JLabel("DENTAL HEALTH");
        this.lblWalrusDentalHealth.setFont(new Font("Tahoma", 1, 16));
        this.lblWalrusDentalHealth.setBounds(172, 315, 177, 16);
        this.pnlWalrus.add(this.lblWalrusDentalHealth);
        this.cboWalrusDentalHealth = new JComboBox();
        this.cboWalrusDentalHealth.setModel(new DefaultComboBoxModel<String>(new String[]{"GOOD", "AVERAGE", "POOR"}));
        this.cboWalrusDentalHealth.setFont(new Font("Tahoma", 1, 16));
        this.cboWalrusDentalHealth.setBounds(511, 313, 100, 22);
        this.pnlWalrus.add(this.cboWalrusDentalHealth);
        this.btnWalrusTrack = new JButton("TRACK WALRUS");
        this.btnWalrusTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntarticWildlifeTracking.this.species = "Walrus";
                if (AntarticWildlifeTracking.this.cboWalrusSex.getSelectedIndex() == 0) {
                    AntarticWildlifeTracking.this.sex = "Male";
                } else {
                    AntarticWildlifeTracking.this.sex = "Female";
                }
                AntarticWildlifeTracking.this.weight = (Integer)AntarticWildlifeTracking.this.spnWalrusWeight.getValue();
                switch (AntarticWildlifeTracking.this.cboWalrusDentalHealth.getSelectedIndex()) {
                    case 0: {
                        AntarticWildlifeTracking.this.dental = "Good";
                        break;
                    }
                    case 1: {
                        AntarticWildlifeTracking.this.dental = "Average";
                        break;
                    }
                    case 2: {
                        AntarticWildlifeTracking.this.dental = "Poor";
                    }
                }
                GPS GPSData = new GPS(AntarticWildlifeTracking.this.latitude, AntarticWildlifeTracking.this.longitude);
                Walrus walrus = new Walrus(AntarticWildlifeTracking.this.species, AntarticWildlifeTracking.this.sex, AntarticWildlifeTracking.this.weight, AntarticWildlifeTracking.this.dental, GPSData);
                try {
                    ReadWrite.writeFile(walrus.createRecord());
                    AntarticWildlifeTracking.this.cboWalrusSex.setSelectedIndex(0);
                    AntarticWildlifeTracking.this.spnWalrusWeight.setValue(new Integer(0));
                    AntarticWildlifeTracking.this.cboWalrusDentalHealth.setSelectedIndex(0);
                    cboPenguinSex.setSelectedIndex(0);
                    spnPenguinWeight.setValue(new Integer(0));
                    AntarticWildlifeTracking.this.txtPenguinBloodPressure.setText("");
                    AntarticWildlifeTracking.this.pnlWalrus.setVisible(false);
                    AntarticWildlifeTracking.this.pnlSaved.setVisible(true);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(AntarticWildlifeTracking.this.pnlPenguin, "File Error! trackingData.txt missing from directory!", "Warning", 2);
                }
            }
        });
        this.btnWalrusTrack.setFont(new Font("Tahoma", 1, 16));
        this.btnWalrusTrack.setBounds(0, 415, 802, 130);
        this.pnlWalrus.add(this.btnWalrusTrack);
        this.btnWalrusBack = new JButton("BACK");
        this.btnWalrusBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntarticWildlifeTracking.this.pnlWalrus.setVisible(false);
                pnlAnimal.setVisible(true);
            }
        });
        this.btnWalrusBack.setFont(new Font("Tahoma", 1, 18));
        this.btnWalrusBack.setBounds(364, 558, 97, 55);
        this.pnlWalrus.add(this.btnWalrusBack);
        this.pnlSeaLion = new JPanel();
        this.contentPane.add((Component)this.pnlSeaLion, "name_53881155077530");
        this.pnlSeaLion.setLayout(null);
        this.lblSeaLionTitle = new JLabel("SEA LION DETAILS:");
        this.lblSeaLionTitle.setIcon(new ImageIcon(AntarticWildlifeTracking.class.getResource("/img/seaLion.png")));
        this.lblSeaLionTitle.setHorizontalAlignment(0);
        this.lblSeaLionTitle.setFont(new Font("Tahoma", 0, 39));
        this.lblSeaLionTitle.setBounds(12, 31, 778, 73);
        this.pnlSeaLion.add(this.lblSeaLionTitle);
        this.lblSeaLionSex = new JLabel("SEX");
        this.lblSeaLionSex.setFont(new Font("Tahoma", 1, 16));
        this.lblSeaLionSex.setBounds(172, 148, 177, 16);
        this.pnlSeaLion.add(this.lblSeaLionSex);
        this.cboSeaLionSex = new JComboBox();
        this.cboSeaLionSex.setModel(new DefaultComboBoxModel<String>(new String[]{"MALE", "FEMALE"}));
        this.cboSeaLionSex.setFont(new Font("Tahoma", 1, 16));
        this.cboSeaLionSex.setBounds(523, 144, 100, 22);
        this.pnlSeaLion.add(this.cboSeaLionSex);
        this.lblSeaLionWeight = new JLabel("WEIGHT (KG)");
        this.lblSeaLionWeight.setFont(new Font("Tahoma", 1, 16));
        this.lblSeaLionWeight.setBounds(172, 231, 177, 16);
        this.pnlSeaLion.add(this.lblSeaLionWeight);
        this.spnSeaLionWeight = new JSpinner();
        this.spnSeaLionWeight.setModel(new SpinnerNumberModel(0, 0, 1000, 1));
        this.spnSeaLionWeight.setFont(new Font("Tahoma", 1, 16));
        this.spnSeaLionWeight.setBounds(523, 227, 100, 22);
        this.pnlSeaLion.add(this.spnSeaLionWeight);
        this.lblSeaLionNumberOfSpots = new JLabel("NUMBER OF SPOTS");
        this.lblSeaLionNumberOfSpots.setFont(new Font("Tahoma", 1, 16));
        this.lblSeaLionNumberOfSpots.setBounds(172, 315, 177, 16);
        this.pnlSeaLion.add(this.lblSeaLionNumberOfSpots);
        this.spnSeaLionSpots = new JSpinner();
        this.spnSeaLionSpots.setModel(new SpinnerNumberModel(new Integer(0), new Integer(0), null, new Integer(1)));
        this.spnSeaLionSpots.setFont(new Font("Tahoma", 1, 16));
        this.spnSeaLionSpots.setBounds(523, 312, 100, 22);
        this.pnlSeaLion.add(this.spnSeaLionSpots);
        this.btnSeaLionTrack = new JButton("TRACK SEA LION");
        this.btnSeaLionTrack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntarticWildlifeTracking.this.species = "Sea Lion";
                if (AntarticWildlifeTracking.this.cboSeaLionSex.getSelectedIndex() == 0) {
                    AntarticWildlifeTracking.this.sex = "Male";
                } else {
                    AntarticWildlifeTracking.this.sex = "Female";
                }
                AntarticWildlifeTracking.this.weight = (Integer)AntarticWildlifeTracking.this.spnSeaLionWeight.getValue();
                AntarticWildlifeTracking.this.spots = (Integer)AntarticWildlifeTracking.this.spnSeaLionSpots.getValue();
                GPS GPSData = new GPS(AntarticWildlifeTracking.this.latitude, AntarticWildlifeTracking.this.longitude);
                SeaLion seaLion = new SeaLion(AntarticWildlifeTracking.this.species, AntarticWildlifeTracking.this.sex, AntarticWildlifeTracking.this.weight, AntarticWildlifeTracking.this.spots, GPSData);
                try {
                    ReadWrite.writeFile(seaLion.createRecord());
                    AntarticWildlifeTracking.this.cboSeaLionSex.setSelectedIndex(0);
                    AntarticWildlifeTracking.this.spnSeaLionWeight.setValue(new Integer(0));
                    AntarticWildlifeTracking.this.spnSeaLionSpots.setValue(new Integer(0));
                    AntarticWildlifeTracking.this.cboWalrusSex.setSelectedIndex(0);
                    AntarticWildlifeTracking.this.spnWalrusWeight.setValue(new Integer(0));
                    AntarticWildlifeTracking.this.cboWalrusDentalHealth.setSelectedIndex(0);
                    cboPenguinSex.setSelectedIndex(0);
                    spnPenguinWeight.setValue(new Integer(0));
                    AntarticWildlifeTracking.this.txtPenguinBloodPressure.setText("");
                    AntarticWildlifeTracking.this.pnlSeaLion.setVisible(false);
                    AntarticWildlifeTracking.this.pnlSaved.setVisible(true);
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                    JOptionPane.showMessageDialog(AntarticWildlifeTracking.this.pnlPenguin, "File Error! trackingData.txt missing from directory!", "Warning", 2);
                }
            }
        });
        this.btnSeaLionTrack.setFont(new Font("Tahoma", 1, 16));
        this.btnSeaLionTrack.setBounds(0, 415, 802, 130);
        this.pnlSeaLion.add(this.btnSeaLionTrack);
        this.btnSeaLionBack = new JButton("BACK");
        this.btnSeaLionBack.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntarticWildlifeTracking.this.pnlSeaLion.setVisible(false);
                pnlAnimal.setVisible(true);
            }
        });
        this.btnSeaLionBack.setFont(new Font("Tahoma", 1, 18));
        this.btnSeaLionBack.setBounds(364, 558, 97, 55);
        this.pnlSeaLion.add(this.btnSeaLionBack);
        this.pnlSaved = new JPanel();
        this.contentPane.add((Component)this.pnlSaved, "name_53904580565333");
        this.pnlSaved.setLayout(null);
        this.btnSavedContinue = new JButton("CONTINUE");
        this.btnSavedContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntarticWildlifeTracking.this.pnlSaved.setVisible(false);
                pnlGPS.setVisible(true);
            }
        });
        this.btnSavedContinue.setBounds(0, 309, 800, 126);
        this.btnSavedContinue.setFont(new Font("Tahoma", 1, 16));
        this.pnlSaved.add(this.btnSavedContinue);
        this.btnSavedData = new JLabel("DATA SAVED!");
        this.btnSavedData.setFont(new Font("Tahoma", 0, 45));
        this.btnSavedData.setHorizontalAlignment(0);
        this.btnSavedData.setBounds(0, 93, 800, 213);
        this.pnlSaved.add(this.btnSavedData);
        this.btnReportContinue = new JButton("CONTINUE");
        this.btnReportContinue.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                AntarticWildlifeTracking.this.pnlReport.setVisible(false);
                pnlGPS.setVisible(true);
            }
        });
        this.btnReportContinue.setBounds(0, 507, 802, 106);
        this.btnReportContinue.setFont(new Font("Tahoma", 1, 16));
        this.pnlReport.add(this.btnReportContinue);
        this.lblReportTitle = new JLabel("TRACKING REPORT:");
        this.lblReportTitle.setBounds(0, 0, 802, 55);
        this.lblReportTitle.setHorizontalAlignment(0);
        this.lblReportTitle.setFont(new Font("Tahoma", 0, 45));
        this.pnlReport.add(this.lblReportTitle);
    }
}

